//###############################################################
//
//	CruiseDlg.cpp : implementation file
//
//	S_CreateCruiseDlg()
//###############################################################

#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "CruiseDlg.h"
#include "afxwin.h"
#include "afxcmn.h"
#include "misc.h"
#include "Comm.h"
#include "Cruise.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//--------------- User defined variable -------------------------
/*
extern	CCruiseDlg		*G_CruiseDlg;
extern int				G_RCtrlID;
extern int				G_CruiseDlgOn;
int						G_TimerOn=0;
*/
//---------------------------------------------------------------
int						G_TimerOn=0;

////////////////////////////////////////////////////////////////
// CCruiseDlg dialog


CCruiseDlg::CCruiseDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCruiseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCruiseDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CCruiseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCruiseDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCruiseDlg, CDialog)
	//{{AFX_MSG_MAP(CCruiseDlg)
	ON_WM_TIMER()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(IDC_CRUISE_RECORD_START,RecordStart)
	ON_COMMAND(IDC_CRUISE_RECORD_STOP,RecordStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////
// CCruiseDlg message handlers


//###############################################################
// 
// S_CreateCruiseDlg()	:
//
//###############################################################
void CCruise::S_CreateCruiseDlg()
{
CCruiseDlg	CruiseDlg;
UINT		CruiseNum;
LPTSTR		CruiseBmpName;

G_CruiseDlg=&CruiseDlg;

G_TimerOn=0;
int nResponse = CruiseDlg.DoModal();
if (nResponse == IDOK)
	{
	CloseHandle(G_CruiseDlg->hCruise);
	CruiseNum=CCruise::S_CruiseIDToNum(G_RCtrlID,&CruiseBmpName);
	CCruise::S_Cruise_ChooseParaFromFile(CruiseNum);

	}
else if (nResponse == IDCANCEL)
	{
	CloseHandle(G_CruiseDlg->hCruise);

	}


G_TimerOn=0;

}


//###############################################################
// 
// OnInitialDialog()	:
//
//###############################################################

BOOL CCruiseDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//-------- Animation bmp
    VERIFY(m_domeBmap.LoadBitmap(IDB_ANIMATION_DOME));
	//------------------------------------------------------------
	hCruise=CreateFile("Cruise.tmp",GENERIC_READ|GENERIC_WRITE,FILE_SHARE_WRITE,NULL,
				CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	m_nEntryFlag=0;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



int CCruiseDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
	if ( !SetTimer(4,100,NULL) )
		{
		MessageBox("Error : SetTimer failed !");
		return -1;
		}
	G_CruiseDlgOn=1;

	return 0;
}

void CCruiseDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	KillTimer(4);
	G_CruiseDlgOn=0;

	CDialog::OnClose();
}


//###############################################################
// 
// RecordStart()	:
//
//###############################################################
void CCruiseDlg::RecordStart() 
{
G_TimerOn=1;

}

//###############################################################
// 
// RecordStop()	:
//
//###############################################################
void CCruiseDlg::RecordStop() 
{
G_TimerOn=0;
FilePosition=0;

PostMessage(WM_COMMAND,IDOK,BN_CLICKED);
}

//###############################################################
// 
// OnTimer()	:
//
//###############################################################
void CCruiseDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
if ( G_TimerOn==1 )
	{
	//----------------------------------------------------------
	char Para[5];
	unsigned char	*Ptr;
	float			Time=0,PanDeg=0,TiltDeg=0,Zoom=0,PanSpeed=0,TiltSpeed=0;

	CComm::RequestDome(Para);
	Ptr=(unsigned char *)Para;

	//-------- Writing temporary para to file --------------------
	DWORD	NumberOfBytesWritten;
	WriteFile(hCruise,Ptr,5,&NumberOfBytesWritten,NULL);

	//--------- Animation ----------------------------------
	TalkDraw(1);

	//---------------------------------------------------------
	}
else
	{
	if ( m_nEntryFlag==0 )
		{
		TalkDraw(0);
		m_nEntryFlag=1;
		}
	}


CDialog::OnTimer(nIDEvent);

}


//################################################################
//
//	TalkDraw()
//
//################################################################

void CCruiseDlg::TalkDraw(UINT transfer)
{ static UINT LED;
  static UINT mx=42;
  static UINT my;
  static UINT direct; // red-point moving direct
  CClientDC dc(GetDlgItem(IDC_DOMES));
    CDC m_dcMem;     //Compatible memory DC for Radar show   
                     // 1.draw in memory 2. paste to frame 
	                 // To avoid Screen gilttering
	CBrush m_brush;  //Handle of null brush
	BITMAP m_bmInfo; //Bitmap information structure 
 	CPoint m_pt;     //Position for upper left corner 
    CSize  m_size;   // Size (width and height) of bitmap
    CRect  rectClient;// Domes-frame   
      
    CBitmap* domeBmap;
	domeBmap=&(m_domeBmap);//get the bitmap from OnInitDialog
	
	m_brush.CreateStockObject(NULL_BRUSH);//Load null brush 
	
	domeBmap->GetObject(sizeof(BITMAP),&m_bmInfo);
	
	GetDlgItem(IDC_DOMES)->GetClientRect(&rectClient);
	
	m_size.cx=rectClient.right;   //Zero based
	m_size.cy=rectClient.bottom;  //Zero based
	m_pt.x=rectClient.left;
	m_pt.y=rectClient.top;
    
   //Create compatible memory DC using the radar-frame
	VERIFY(m_dcMem.CreateCompatibleDC(&dc));
   // load radar-frame's bitmap to memory
    m_dcMem.SelectObject(domeBmap);

    CPen*     pen;    //for change different color pen and brush
    CBrush* brush; 
    pen=new CPen(PS_SOLID,1,RGB(190,190,190)); 
    brush=new CBrush(RGB(190,190,190));
   
  CBrush* oldBrush=m_dcMem.SelectObject(brush);
  CPen*   oldPen = m_dcMem.SelectObject(pen);
   
  m_dcMem.SelectObject(brush);
  m_dcMem.SelectObject(pen);
  
  UINT width,height,cx,cy; 
 
  width=rectClient.Width();
  height=rectClient.Height();
  
  cx=rectClient.right/2;
  cy=rectClient.bottom/2;

  m_dcMem.Rectangle(42,cy-9,width,cy+9);  
   
  m_dcMem.SelectObject(oldBrush);
  m_dcMem.SelectObject(oldPen);
  delete pen;
  delete brush;	  
  
  pen=new CPen(PS_SOLID,1,RGB(31,31,31)); 
  brush=new CBrush(RGB(192,192,192));
   
  m_dcMem.SelectObject(brush);
  m_dcMem.SelectObject(pen);
  
  m_dcMem.MoveTo(38,cy);  //Draw the line between the domes
  m_dcMem.LineTo(245,cy);

  m_dcMem.MoveTo(86,cy);
  m_dcMem.LineTo(86,cy+10);
  
  m_dcMem.MoveTo(122,cy);
  m_dcMem.LineTo(122,cy-10);
 
  m_dcMem.MoveTo(158,cy);
  m_dcMem.LineTo(158,cy+10);
  
  m_dcMem.MoveTo(194,cy);
  m_dcMem.LineTo(194,cy-10);

  m_dcMem.SelectObject(oldBrush);
  m_dcMem.SelectObject(oldPen);
  delete pen;
  delete brush;	  
if(transfer==1)
{  
  pen=new CPen(PS_SOLID,1,RGB(255,0,0)); 
  brush=new CBrush(RGB(255,0,0));
         
  m_dcMem.SelectObject(brush);
  m_dcMem.SelectObject(pen);
  

 if(direct==0)   // Draw moving red-point 
 {               // direct=0, red-point right-moving
    if(mx<120)
	{ 
    mx=mx+6;
    m_dcMem.Rectangle(mx,cy-2,mx+4,cy+2);
	}
  
    if(mx==120)
	{ 
    my+=1;
    m_dcMem.Rectangle(mx,cy-2-my,mx+4,cy+2-my);
     if(my==6)
	 {
     direct=1;
	 }
	}
 }
 
 if(direct==1) // direct=1, red-point left-moving
 {
  if(mx==120)
  {   my-=1;
	  m_dcMem.Rectangle(mx,cy-2-my,mx+4,cy+2-my);
      
    if(my==0)
	{ mx-=6;
	  m_dcMem.Rectangle(mx,cy-2,mx+4,cy+2);
      
	}
  }
  if(mx<120)
  {  mx-=6;
	 m_dcMem.Rectangle(mx,cy-2,mx+4,cy+2);
	
 	if(mx==42)
	{
     direct=0;
	}
  }
  
 }

  m_dcMem.SelectObject(oldBrush);
  m_dcMem.SelectObject(oldPen);
  delete pen;
  delete brush;	  

  switch(LED)
  {
  case 0:
    pen=new CPen(PS_SOLID,1,RGB(0,255,115)); 
    brush=new CBrush(RGB(0,255,115));
	LED=1;
  break;
  case 1:
    pen=new CPen(PS_SOLID,1,RGB(194,206,153)); 
    brush=new CBrush(RGB(194,206,153));
	LED=0;
  break; 
  }
  m_dcMem.SelectObject(brush);
  m_dcMem.SelectObject(pen);
   
  m_dcMem.Rectangle(20,35,23,37);
  
  m_dcMem.SelectObject(oldBrush);
  m_dcMem.SelectObject(oldPen);
  delete pen;
  delete brush;	  
}
   // Paste Line picture form memory to Domes-frame 
   dc.BitBlt(m_pt.x,m_pt.y,m_size.cx,m_size.cy,    
            &m_dcMem,0,0,SRCCOPY);          

}// end of CommDialog::TalkDraw()
